// Fediverso Box JS
// File Version: 4
// Last Modified: 2025-08-01
// Author: Emanuele Gori

document.addEventListener('DOMContentLoaded', function () {
  var form = document.getElementById('fediFollowForm');
  if (!form) return;
  form.onsubmit = function (e) {
    e.preventDefault();
    var input = document.getElementById('fediUserInput').value.trim().toLowerCase();

    // Permetti solo il dominio dell'istanza, es: mastodon.uno
    var match = input.match(/^[a-z0-9.-]+\.[a-z]{2,}$/i);
    if (!match) {
      alert('Inserisci solo il dominio della tua istanza Mastodon (es: mastodon.uno)');
      return false;
    }

    var url = 'https://' + input + '/authorize_interaction?uri=emanuelegori@emanuelegori.uno';
    window.open(url, '_blank');
    return false;
  };
});
