<?php
/*
Plugin Name: Fediverso Box
Description: Mostra un box per seguire l'autore nel Fediverso.
Version: 1.2
File Version: 5
Last Modified: 2025-08-21
Author: Emanuele Gori
Text Domain: fediverso-box
*/

if (!defined('ABSPATH')) exit;

// Carica sempre CSS e JS per compatibilità con chiamata PHP diretta e shortcode
add_action('wp_enqueue_scripts', function() {
    wp_enqueue_style('fediverso-box-style', plugin_dir_url(__FILE__) . 'fediverso-style.css');
    wp_enqueue_script('fediverso-box-js', plugin_dir_url(__FILE__) . 'fediverso-script.js', array(), null, true);
});

// Funzione richiamabile sia da shortcode che da PHP
if (!function_exists('fediverso_box')) {
    function fediverso_box($atts = array()) {
        $author_handle = 'emanuelegori@emanuelegori.uno';

        ob_start();
        ?>
        <div class="mastodon-box">
            <p>
                🇮🇹 <?php echo esc_html__('Ricevi i prossimi articoli direttamente nel tuo feed (i Seguiti) del Fediverso.', 'fediverso-box'); ?>
                (<a href="https://fediverso.info/" target="_blank"><?php echo esc_html__('Non conosci il Fediverso?', 'fediverso-box'); ?></a>)<br>
                <span><?php echo esc_html__('Segui', 'fediverso-box'); ?> <span><?php echo esc_html($author_handle); ?></span></span>
            </p>
            <form id="fediFollowForm" autocomplete="off">
                <input type="text" id="fediUserInput" placeholder="Istanza es. mastodon.uno">
                <button type="submit" id="fediFollowBtn">Segui</button>
            </form>
            <small>
                <?php echo esc_html__('Non hai un account?', 'fediverso-box'); ?>
                <a href="https://mastodon.uno/auth/sign_up" target="_blank"><?php echo esc_html__('Crea un profilo gratuito', 'fediverso-box'); ?></a>
            </small>
        </div>
        <?php
        return ob_get_clean();
    }
}

// Shortcode
add_shortcode('fediverso_box', function($atts) {
    return fediverso_box($atts);
});
